// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#if defined(_WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif
#include "math.h"

inline void assert(bool b)
{
	if(b)
		return;
	printf("Assertion fehlgeschlagen!\n");
	while(true)
		;
}

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;
typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int dword;
const int MaxInt = 0x7FFFFFFF;

//#pragma warning( disable: 4309)

class Asteroid
{
public:
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein

	void set(int x, int y, int type, int sf);
};

class Shot
{
public:
	int x;
	int y;

	void set(int x, int y);
};

class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;
	bool saucer_present;// UFO sichtbar
	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_size;    // Gre: 15 = gro, 14 = klein
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];
	void clear(void);
};

#pragma pack(1)

class KeysPacket
{
private:
	char signature[6];
public:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char keys;
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};



enum RAM_Type
{
/*0x18*/	RAM_CurrentPlayer,
/*0x1C*/	RAM_NumPlayers,
/*0x52*/	RAM_PlayerScoreTens,
/*0x53*/	RAM_PlayerScoreThousends,
/*0x57*/	RAM_cShips,
/*0x59*/	RAM_HyperSpaceStatus,
/*0x5C*/	RAM_FastTimer,
/*0x5D*/	RAM_SlowTimer,
/*0x5F*/	RAM_RandomSeed1,
/*0x60*/	RAM_RandomSeed2,
/*0x61*/	RAM_ShipDirection,
/*0x63*/	RAM_FireHyperspaceToggle,
/*0x64*/	RAM_AccX,
/*0x65*/	RAM_AccY,
/*0x02F5*/	RAM_NumAsteroidsStart,
/*0x02F6*/	RAM_NumAsteroids,
/*0x02F7*/	RAM_SaucerCountdown,
/*0x02F8*/	RAM_SaucerCountdownStart,
/*0x02FA*/	RAM_InvisibleTimer,
/*0x02FB*/	RAM_NewLevelStartCountdown,
///*0x02FC*/	RAM_2FC,
///*0x02FD*/	RAM_2FD,
			RAM_Count
};
const int ByteAddress[RAM_Count] = 
{
	0x18,
	0x1C,
	0x52,
	0x53,
	0x57,
	0x59,
	0x5C,
	0x5D,
	0x5F,
	0x60,
	0x61,
	0x63,
	0x64,
	0x65,
	0x02F5,
	0x02F6,
	0x02F7,
	0x02F8,
	0x02FA,
	0x02FB,
//	0x02FC,
//	0x02FD,
};

enum RAMO_Type
{
/*0x200*/	RAMO_Status,
/*0x223*/	RAMO_VelocityX,
/*0x246*/	RAMO_VelocityY,
/*0x269*/	RAMO_PositionX,
/*0x28C*/	RAMO_PositionY,
/*0x2AF*/	RAMO_PositionExactX,
/*0x2D2*/	RAMO_PositionExactY,
			RAMO_Count
};

const int RAMO_Address[RAMO_Count] =
{
	0x200,
	0x223,
	0x246,
	0x269,
	0x28C,
	0x2AF,
	0x2D2,
};

const int AsteroidMinIndex =   0x00;
const int AsteroidMaxIndex =   0x1A;
const int PlayerIndex =        0x1B;
const int SaucerIndex =        0x1C;
const int SaucerShotMinIndex = 0x1D;
const int SaucerShotMaxIndex = 0x1E;
const int PlayerShotMinIndex = 0x1F;
const int PlayerShotMaxIndex = 0x25;
const int NumObjects = 0x26;

const int ShotLifetime = 0x12 * 4;
const int RotationSpeed = 3;

inline bool MoveLinearXSingle(word& PositionX, char VelocityX)
{
	PositionX += VelocityX;
	if(PositionX >= 0x2000)//Objekt geht rechts oder links raus
	{
		PositionX &= 0x1FFF;//andere Seite wieder rein
		return true;
	}
	return false;
}

inline word MoveLinearX(word PositionX, char VelocityX, int Steps)
{
	return (PositionX + VelocityX*Steps) & 0x1FFF;
/*	word oldPositionX = PositionX;
	for(int i = 0; i < Steps; i++)
	{
		PositionX += char(VelocityX);
		if(PositionX >= 0x2000)//Objekt geht rechts raus
		{
			PositionX &= 0x1FFF;//links wieder rein
		}
	}
	if(PositionX != ((oldPositionX+char(VelocityX)*Steps)&0x1FFF))
		assert(0);
	return PositionX;*/
}

inline word MoveLinearY(word PositionY, char VelocityY, int Steps)
{
	PositionY += VelocityY*Steps;
	if(VelocityY >= 0)
	{
		if(PositionY >= 0x1800)
			PositionY -= 0x1800;
	}
	else
		if(PositionY >= 0x1800)
			PositionY += 0x1800;
	return PositionY;
/*	word oldPositionY = PositionY;
	word realoldPositionY = PositionY;
	for(int i = 0; i < Steps; i++)
	{
		PositionY += char(VelocityY);
		if(PositionY>>8 == 0x0018)//Objekt geht unten raus
		{
			PositionY = 0x0000 | (PositionY&0x00FF);
		}
		else if(PositionY >= 0x1800)
		{
			PositionY = 0x1700 | (PositionY&0x00FF);
		}
	}
	if(PositionY != oldPositionY)
		assert(0);
	return PositionY;*/
}


struct DirInfo
{
	word StartX, StartY;
	char VelocityX, VelocityY;
	int CollisionAtTime;
	int ShotTime;

	int PositionX(int t)
	{
		return MoveLinearX(StartX, VelocityX, t);
	}
	int PositionY(int t)
	{
		return MoveLinearY(StartY, VelocityY, t);
	}
	int PositionXEasy(int t)
	{
		return int(StartX)+int(VelocityX)*t;
	}
	int PositionYEasy(int t)
	{
		return int(StartY)+int(VelocityY)*t;
	}
};
extern DirInfo BestDirInfo;
extern bool ErrorsOccured;
extern word CollisionShotX[4];
extern word CollisionShotY[4];
extern bool updating;
extern __int64* pScore;

inline word MakeWord(byte high, byte low)
{
	return word(high)<<8 | word(low);
}
inline void MakeBytesFromWord(word Word, byte& High, byte& Low)
{
	High = byte(Word>>8);
	Low = byte(Word);
}
inline byte& LowByte(word& Word)
{
	return (byte&)Word;
}
inline byte& HighByte(word& Word)
{
	return *(((byte*)&Word)+1);
}
inline byte Half(byte value)
{
	if(char(value) >= 0)
		return value/2;
	else
		return char(value-1)/2;
}
inline void Clamp(byte& value, byte min, byte max)
{
	if(char(value) >= 0)
	{
		if(value > max)
			value = max;
	}
	else
	{
		if(value < min)
			value = min;
	}
}
template<typename T>
T Min(T a, T b)
{
	return a<b ? a : b;
}
inline word DecimalToBin(byte High, byte Low)
{
	return (High>>4)*1000 + (High&0x0F)*100 + (Low>>4)*10 + (Low&0x0F);
}
inline void BinToDecimal(word Bin, byte& High, byte& Low)
{
	Low = Bin%10;
	Bin /= 10;
	Low |= Bin%10 << 4;
	Bin /= 10;
	High = Bin%10;
	Bin /= 10;
	High |= Bin%10 << 4;
}
inline byte& ShiftLeft(byte& byte, bool& carry)
{
	carry = (byte>>7) != 0;
	byte <<= 1;
	return byte;
}
inline byte& RotateLeft(byte& byte, bool& carry)
{
	bool newcarry = (byte>>7) != 0;
	byte <<= 1;
	if(carry) byte |= 1;
	carry = newcarry;
	return byte;
}
inline byte& ShiftRight(byte& byte, bool& carry)
{
	carry = (byte&1) != 0;
	byte >>= 1;
	return byte;
}
inline byte& RotateRight(byte& byte, bool& carry)
{
	bool newcarry = (byte&1) != 0;
	byte >>= 1;
	if(carry) byte |= 0x80;
	carry = newcarry;
	return byte;
}
inline byte& Add(byte& a, byte b, bool& carry)
{
	int sum = a + int(b) + carry;
	carry = (sum & 0xFF00) != 0;
	a = (byte)sum;
	return a;
}
inline byte& Subtract(byte& a, byte b, bool& carry)
{
	int c = (carry ? 1 : 0) ^ 1;
	int dif = a - int(b) - c;
	carry = (dif & 0xff00) == 0;
	a = (byte)dif;
	return a;
}

class GameRam
{
	byte ram[0x300];

public:
	void StartNewGame()
	{
		memset(ram, 0, 0x300);
		Var(RAM_NumPlayers) = 1;
		Var(RAM_cShips) = 3;
		Var(RAM_RandomSeed1) = 0;
		Var(RAM_NumAsteroidsStart) = 2;
		Var(RAM_InvisibleTimer) = 1;
		Var(RAM_SaucerCountdownStart) = Var(RAM_SaucerCountdown) = 0x92;
		Var(RAM_NewLevelStartCountdown) = 0x7F;
		ResetPlayerPosition();
	}
	KeysPacket CalcDirInfos();
	void Render(HDC hdcScreen, int cx, int cy)
	{
		HBITMAP hBitmap = CreateCompatibleBitmap(hdcScreen, cx, cy);
		HDC hdc = CreateCompatibleDC(hdcScreen);
		SelectObject(hdc, hBitmap);

		RECT rc;
		SetRect(&rc, 0, 0, cx, cy);
		FillRect(hdc, &rc, (HBRUSH)GetStockObject(updating ? WHITE_BRUSH : LTGRAY_BRUSH));


		SelectObject(hdc, GetStockObject(NULL_BRUSH));
		for(int Pass = 0; Pass < 2; Pass++)
		{
			for(int i = 0; i < NumObjects; i++)
			{
				if(VarO(RAMO_Status, i)==0)
					continue;
				if(char(VarO(RAMO_Status, i)) < 0 && Pass != 0 || //Explosion im ersten Pass zeichnen
					char(VarO(RAMO_Status, i)) >= 0 && Pass == 0)
					continue;
				int Size = 100;
				if(char(VarO(RAMO_Status, i)) < 0)//Explosion
					Size = -char(VarO(RAMO_Status, i));
				else if(i==PlayerIndex)
					Size = 12;
				else if(i==SaucerIndex)
					Size = 0;
				else if(i<PlayerIndex && (VarO(RAMO_Status, i)&0x01))
				{
					Size = 13;
				}
				else if(i<PlayerIndex && (VarO(RAMO_Status, i)&0x02))
					Size = 20;
				else if(i<PlayerIndex && (VarO(RAMO_Status, i)&0x04))
					Size = 30;
				else if(i>SaucerIndex)
					Size = 4;
				else
					assert(0);
				int x = int(MakeWord(VarO(RAMO_PositionX, i), VarO(RAMO_PositionExactX, i))) * cx / 0x2000;
				int y = int(MakeWord(VarO(RAMO_PositionY, i), VarO(RAMO_PositionExactY, i))) * cy / 0x1800;
				y = cy - y;
				if(Size)
					Ellipse(hdc, x-Size*cx/1033, y-Size*cy/733, x+Size*cx/1033, y+Size*cy/733);
				else
					Rectangle(hdc, x-10, y-10, x+10, y+10);
				if(i==PlayerIndex)
				{
					MoveToEx(hdc, x, y, 0);
					LineTo(hdc, int(cos(float(Var(RAM_ShipDirection))/255.f*6.283f)*20.0f)+x,
								int(sin(float(Var(RAM_ShipDirection))/255.f*6.283f)*-20.0f)+y);
				}
			}
			SelectObject(hdc, GetStockObject(WHITE_BRUSH));
		}
//		CalcDirInfos();
//		for(int i = 0; i < 0x100; i++)
		if(BestDirInfo.CollisionAtTime != MaxInt)
		{
			int x = int(BestDirInfo.StartX) * cx / 0x2000;
			int y = int(BestDirInfo.StartY) * cy / 0x1800;
			y = cy - y;
			MoveToEx(hdc, x, y, 0);
			x = BestDirInfo.PositionXEasy(BestDirInfo.ShotTime) * cx / 0x2000;
			y = BestDirInfo.PositionYEasy(BestDirInfo.ShotTime) * cy / 0x1800;
			y = cy - y;
			LineTo(hdc, x, y);
		}
		
		/*for(int x = 0; x < cx; x++)
		for(int y = 0; y < cy; y++)
		{
			int xAst = x * 0x2000 / cx;
			int yAst = (cy-y) * 0x1800 / cy;
			for(int Object = SaucerIndex; Object >= 0; Object--)
			{
				if(char(VarO(RAMO_Status, Object)) <= 0)
					continue;
				bool collision = AreObjectsNear(0x1F, xAst, yAst,
												Object,
												MakeWord(VarO(RAMO_PositionX, Object), VarO(RAMO_PositionExactX, Object)),
												MakeWord(VarO(RAMO_PositionY, Object), VarO(RAMO_PositionExactY, Object)));
				if(collision)
					SetPixel(hdc, x, y, RGB(255,0,0));
			}
		}*/

		BitBlt(hdcScreen, 0, 0, cx, cy, hdc, 0, 0, SRCCOPY);
		DeleteDC(hdc);
		DeleteObject(hBitmap);
	}
	byte* GetRawRam()
	{
		return ram;
	}
	byte& Var(RAM_Type type)
	{
		return ram[ByteAddress[type]];
	}
	const byte& Var(RAM_Type type) const
	{
		return ram[ByteAddress[type]];
	}
	byte& VarO(RAMO_Type type, int index)
	{
		return ram[RAMO_Address[type]+index];
	}
	const byte& VarO(RAMO_Type type, int index) const
	{
		return ram[RAMO_Address[type]+index];
	}
	bool Check(const byte* ram2, const KeysPacket& keys)
	{
/*		byte s1 = Var(RAM_RandomSeed1);
		byte s2 = Var(RAM_RandomSeed2);
		Rand();
		int i = 0;
		while(s1 != Var(RAM_RandomSeed1) || s2 != Var(RAM_RandomSeed2))
		{
			printf("%i: %x%x\n", ++i, Var(RAM_RandomSeed1), Var(RAM_RandomSeed2));
			Rand();
		}
		while(true);*/
	
		bool errors = false;
		for(int i=0; i < RAM_Count; i++)
			if(//i!=RAM_RandomSeed1 && i!=RAM_RandomSeed2 &&
				//i!=RAM_FireHyperspaceToggle &&
				i!=RAM_cShips &&
				//i!=RAM_PlayerScoreTens && i!=RAM_PlayerScoreThousends &&
				i!=RAM_SaucerCountdown && i!=RAM_SaucerCountdownStart &&
				//i!=RAM_PositionExactX && i!=RAM_PositionExactY &&
				//i!=RAM_PositionX && i!=RAM_PositionY &&
				//i!=RAM_VelocityY && i!=RAM_AccY &&
				ram[ByteAddress[i]] != ram2[ByteAddress[i]])
			{
				printf("Byte an Adresse %x verschieden: berechnet: %x tatschlich %x\n", ByteAddress[i], ram[ByteAddress[i]], ram2[ByteAddress[i]]);
				errors = true;
			}

		for(int i = 0; i < NumObjects; i++)
			for(int j = 0; j < RAMO_Count; j++)
				if((ram[RAMO_Address[RAMO_Status]+i] || ram2[RAMO_Address[RAMO_Status]+i]) &&
					ram[RAMO_Address[j]+i] != ram2[RAMO_Address[j]+i])
				{
					printf("Byte bei Obj %x an Adresse %x verschieden: berechnet: %x tatschlich %x\n",
						i, RAMO_Address[j], ram[RAMO_Address[j]+i], ram2[RAMO_Address[j]+i]);
					errors = true;
				}
		while(errors)
		{
			*this = last_ram;
			Move(keys);
		}


		return errors;
	}
	static GameRam last_ram;
	void Move(const KeysPacket& keys)
	{
		last_ram = *this;
		
		if(++Var(RAM_FastTimer) == 0)
			Var(RAM_SlowTimer)++;

		//sub_6885
		if(Var(RAM_NumPlayers) &&
			VarO(RAMO_Status, PlayerIndex)==0 &&
			Var(RAM_InvisibleTimer) == 0x80)
		{
			Var(RAM_InvisibleTimer) = 0x10;
		}

		Shoot(keys);
		DoHyperSpace(keys);
		UpdateHyperspace(keys); //Ruft UpdateDirectionAndThrust() auf
		//UpdateSaucer();

		//Objekte aktualisieren
		for(int i = NumObjects-1; i >= 0; i--)
			MoveObject(i);

		// Kollision fr Spielerschsse(4), Saucerschsse(2), Saucer und Schiff prfen
		for(int i = PlayerShotMaxIndex; i >= PlayerIndex; i--)
			CheckCollisions(i);

		Rand();

		//sub_7BC0

		byte a = Var(RAM_NewLevelStartCountdown);
		if(a)
			Var(RAM_NewLevelStartCountdown)--;
		if((a | Var(RAM_NumAsteroids)) == 0)
			ResetAsteroids();
	}
	byte Hash()
	{
		byte h = 0;
		for(int i = 0x200; i < 0x2F4; i++)
			h += ram[i];
		h += ram[0x5F];
		h += ram[0x60];
		return h;
	}

	void Shoot(const KeysPacket& keys)//sub_6CD7
	{
		if(Var(RAM_NumPlayers) == 0)
			return;
		Var(RAM_FireHyperspaceToggle) >>= 1;
		if(keys.keys & KeysPacket::KEY_FIRE)
			Var(RAM_FireHyperspaceToggle) |= 0x80;
		if(!(keys.keys & KeysPacket::KEY_FIRE))
			return;
		if(Var(RAM_FireHyperspaceToggle) & 0x40)//letzten Frame schon gedrckt?
			return;
		if(Var(RAM_InvisibleTimer))
			return;
		int NewShot = PlayerShotMaxIndex;
		while(VarO(RAMO_Status, NewShot))
			if(NewShot-- == PlayerShotMinIndex)
				return;
		VarO(RAMO_Status, NewShot) = ShotLifetime/4;

		word PositionX = MakeWord(VarO(RAMO_PositionX, PlayerIndex), VarO(RAMO_PositionExactX, PlayerIndex)),
			 PositionY = MakeWord(VarO(RAMO_PositionY, PlayerIndex), VarO(RAMO_PositionExactY, PlayerIndex));
		char VelocityX = char(VarO(RAMO_VelocityX, PlayerIndex)),
			 VelocityY = char(VarO(RAMO_VelocityY, PlayerIndex));

		ShootLocationFromAngle(Var(RAM_ShipDirection), PositionX, PositionY, VelocityX, VelocityY);

		MakeBytesFromWord(PositionX, VarO(RAMO_PositionX, NewShot), VarO(RAMO_PositionExactX, NewShot));
		MakeBytesFromWord(PositionY, VarO(RAMO_PositionY, NewShot), VarO(RAMO_PositionExactY, NewShot));
		VarO(RAMO_VelocityX, NewShot) = VelocityX;
		VarO(RAMO_VelocityY, NewShot) = VelocityY;

/*		//xVelocity
		byte a = Var(RAM_ShipDirection);
		CosLookup(a);
		bool c = a >= 0x80;
		RotateRight(a, c);
		byte tmp9 = a;
		a += VarO(RAMO_VelocityX, PlayerIndex);
		Clamp(a, 0x91, 0x6F);
		VarO(RAMO_VelocityX, PlayerIndex+NewShot) = a;

		//yVelocity
		a = Var(RAM_ShipDirection);
		SinLookup(a);
		c = a >= 0x80;
		RotateRight(a, c);
		byte tmpC = a;
		a += VarO(RAMO_VelocityY, PlayerIndex);
		Clamp(a, 0x91, 0x6F);
		VarO(RAMO_VelocityY, PlayerIndex+NewShot) = a;

		//xPosition
		a = tmp9;
		byte tmp8 = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmp9;
		c = false;
		Add(a, VarO(RAMO_PositionExactX, PlayerIndex), c);
		VarO(RAMO_PositionExactX, PlayerIndex+NewShot) = a;
		Add(tmp8, VarO(RAMO_PositionX, PlayerIndex), c);
		VarO(RAMO_PositionX, PlayerIndex+NewShot) = tmp8;

		//yPosition
		a = tmpC;
		byte tmpB = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmpC;
		c = false;
		Add(a, VarO(RAMO_PositionExactY, PlayerIndex), c);
		VarO(RAMO_PositionExactY, PlayerIndex+NewShot) = a;
		Add(tmpB, VarO(RAMO_PositionY, PlayerIndex), c);
		VarO(RAMO_PositionY, PlayerIndex+NewShot) = tmpB;*/
	}
	static void ShootLocationFromAngle(byte Direction, word& PositionX, word& PositionY, char& VelocityX, char& VelocityY)
	{
		//xVelocity
		byte a = Direction;
		CosLookup(a);
		bool c = a >= 0x80;
		RotateRight(a, c);
		byte tmp9 = a;
		a += byte(VelocityX);
		Clamp(a, 0x91, 0x6F);
		VelocityX = char(a);

		//yVelocity
		a = Direction;
		SinLookup(a);
		c = a >= 0x80;
		RotateRight(a, c);
		byte tmpC = a;
		a += byte(VelocityY);
		Clamp(a, 0x91, 0x6F);
		VelocityY = char(a);

		//xPosition
		/*a = tmp9;
		byte tmp8 = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmp9;
		c = false;
		Add(a, LowByte(PositionX), c);
		LowByte(PositionX) = a;
		Add(tmp8, HighByte(PositionX), c);
		HighByte(PositionX) = tmp8;*/
		PositionX += char(tmp9) + char(Half(tmp9));

		//yPosition
/*		a = tmpC;
		byte tmpB = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmpC;
		c = false;
		Add(a, LowByte(PositionY), c);
		LowByte(PositionY) = a;
		Add(tmpB, HighByte(PositionY), c);
		HighByte(PositionY) = tmpB;*/
		PositionY += char(tmpC) + char(Half(tmpC));

	}

	void DoHyperSpace(const KeysPacket& keys)//sub_6E74
	{
		if(!(keys.keys & KeysPacket::KEY_HYPERSPACE) ||
			Var(RAM_NumPlayers) == 0 ||
			Var(RAM_InvisibleTimer) ||
			char(VarO(RAMO_Status, PlayerIndex)) < 0)
			return;

		VarO(RAMO_Status, PlayerIndex) = 0;
		VarO(RAMO_VelocityX, PlayerIndex) = 0;
		VarO(RAMO_VelocityY, PlayerIndex) = 0;
		Var(RAM_InvisibleTimer) = 0x30;

		byte a = Rand() & 0x1F;
		if(a >= 0x1D)
			a = 0x1C;
		if(a < 3)
			a = 3;
		VarO(RAMO_PositionX, PlayerIndex) = a;
	
		for(int i = 0; i < 4; i++)
			Rand();
		a = Rand() & 0x1F;
		Var(RAM_HyperSpaceStatus) = 1;
		if(a >= 0x18)
		{
			a &= 7;
			bool c;
			ShiftLeft(a, c);
			Add(a, 4, c);
			if(a >= Var(RAM_NumAsteroids))//HyperSpace fehlgeschlagen
				Var(RAM_HyperSpaceStatus) = 0x80;
		}
		Clamp(a, 3, 0x14);
		VarO(RAMO_PositionY, PlayerIndex) = a;
	}

	void UpdateHyperspace(const KeysPacket& keys)//sub_703F
	{
		if(Var(RAM_NumPlayers) == 0 ||
			char(VarO(RAMO_Status, PlayerIndex)) < 0)
			return;
		if(Var(RAM_InvisibleTimer) == 0)
		{
			UpdateDirectionAndThrust(keys);
			return;
		}
		if(--Var(RAM_InvisibleTimer))
			return;
		if(char(Var(RAM_HyperSpaceStatus)) < 0) goto loc_706F;
		if(Var(RAM_HyperSpaceStatus)) goto loc_7068;
		if(!CanShipAppear()) goto loc_7081;
		if(VarO(RAMO_Status, SaucerIndex))
		{
			Var(RAM_InvisibleTimer) = 2;
			return;
		}
loc_7068:
		VarO(RAMO_Status, PlayerIndex) = 1;
		goto loc_7081;
loc_706F:
		VarO(RAMO_Status, PlayerIndex) = 0xA0;
		Var(RAM_cShips)--;
		Var(RAM_InvisibleTimer) = 0x81;
loc_7081:
		Var(RAM_HyperSpaceStatus) = 0;
	}

	bool CanShipAppear()
	{
		for(int i = SaucerIndex; i >= 0; i--)
		{
			if(VarO(RAMO_Status, i) == 0)
				continue;

			byte dif = VarO(RAMO_PositionX, i)-VarO(RAMO_PositionX, PlayerIndex);
			if(dif < 0xFC && dif >= 4)
				continue;

			dif = VarO(RAMO_PositionY, i)-VarO(RAMO_PositionY, PlayerIndex);
			if(dif < 0xFC && dif >= 4)
				continue;

			Var(RAM_InvisibleTimer)++;
			return false;
		}
		return true;
	}

	void UpdateDirectionAndThrust(const KeysPacket& keys)//loc_7086
	{
		if(keys.keys & KeysPacket::KEY_LEFT)
			Var(RAM_ShipDirection) += RotationSpeed;
		else if(keys.keys & KeysPacket::KEY_RIGHT)
			Var(RAM_ShipDirection) -= RotationSpeed;
		
		if(Var(RAM_FastTimer) & 1)
			return;
		if(keys.keys & KeysPacket::KEY_THRUST)
		{
			byte y = 0;
			byte a = Var(RAM_ShipDirection);//a=0
			CosLookup(a);
			if(char(a) < 0)
				y--;
			a <<= 1;   //a=80/FE
			bool c = false;
			Add(a, Var(RAM_AccX), c);//a=f9  c=1
			byte x = a;//x=77
			a = y;
			Add(a, VarO(RAMO_VelocityX, PlayerIndex), c);//a=2
			sub7125(a, x);
			VarO(RAMO_VelocityX, PlayerIndex) = a;
			Var(RAM_AccX) = x;

			y = 0;
			a = Var(RAM_ShipDirection);
			SinLookup(a);
			if(char(a) < 0)
				y--;
			a <<= 1;
			c = false;
			Add(a, Var(RAM_AccY), c);
			x = a;
			a = y;
			Add(a, VarO(RAMO_VelocityY, PlayerIndex), c);
			sub7125(a, x);
			VarO(RAMO_VelocityY, PlayerIndex) = a;
			Var(RAM_AccY) = x;
		}
		else
		{
			// KEY_THRUST nicht gedrckt:
			if(VarO(RAMO_VelocityX, PlayerIndex) | Var(RAM_AccX))
			{
				byte a = (VarO(RAMO_VelocityX, PlayerIndex) << 1) ^ 0xFF;
				bool c = char(a) >= 0;
				byte x = c ? 0 : 0xFF;
				Add(Var(RAM_AccX), a, c);
				Add(VarO(RAMO_VelocityX, PlayerIndex), x, c);
			}
			if(VarO(RAMO_VelocityY, PlayerIndex) | Var(RAM_AccY))
			{
				byte a = (VarO(RAMO_VelocityY, PlayerIndex) << 1) ^ 0xFF;
				bool c = char(a) >= 0;
				byte x = c ? 0 : 0xFF;
				Add(Var(RAM_AccY), a, c);
				Add(VarO(RAMO_VelocityY, PlayerIndex), x, c);
/*		
				char a = Var(RAM_VelocityY)<<1;
				char x = 0xFF;
				a ^= 0xFF;
				bool c = false;
				if(a >= 0)
				{
					x++;
					c = true;
				}
				int sum = int(a)+int(Var(RAM_AccY))+c;
				bool overflow = (sum & 0xFF00) != 0;
				a = sum;
				Var(RAM_AccY) = a;
				a = x;
				a += Var(RAM_VelocityY) + overflow;
				Var(RAM_VelocityY) = a;*/
			}
		}
	}


	void MoveObject(int i)
	{
		//byte tmp4, tmp5, tmp6, tmp7;
		byte a = VarO(RAMO_Status, i);
		if(a == 0)
			return;
		//loc_6F62
		if(char(a) < 0)
		{
			//Objekt explodiert
			a = ((a^0xFF)+1) >> 4;
			bool c = true;
			if(i == PlayerIndex)
			{
				c = (Var(RAM_FastTimer)&1) != 0;
				a = 0;
			}
			//loc_6F77
			Add(a, VarO(RAMO_Status, i), c);
			if(char(a) < 0)
			{//loc_6FA1
				VarO(RAMO_Status, i) = a;
				//a = (a&0xF0)+0x10;
				//if(i == PlayerIndex)
				//	a = 0;
				//byte y = a;
				//4567a = VarO(RAMO_PositionExactX, i);
				{//loc_7027
					//sub_72FE
				}
			}
			else if(i == PlayerIndex)
			{//loc_6F93
				ResetPlayerPosition();
				VarO(RAMO_Status, i) = 0;
			}
			else if(i > PlayerIndex)
			{//loc_6F99
			}
			else
			{
				if(--Var(RAM_NumAsteroids) == 0)
					Var(RAM_NewLevelStartCountdown) = 0x7F;
				VarO(RAMO_Status, i) = 0;
			}
			return;
		}
		//loc_6FC7
//		byte y = 0;

		word xPosition = MakeWord(VarO(RAMO_PositionX, i), VarO(RAMO_PositionExactX, i));
		//xPosition += char(VarO(RAMO_VelocityX, i));
		/*a = VarO(RAMO_VelocityX, i);
		if(char(a) < 0)
			y--;
		bool c = false;
		Add(a, VarO(RAMO_PositionExactX, i), c);
		VarO(RAMO_PositionExactX, i) = a;
		a = y;
		Add(a, VarO(RAMO_PositionX, i), c);*/
//		if(a >= 0x20)//Objekt geht rechts raus
		if(MoveLinearXSingle(xPosition, VarO(RAMO_VelocityX, i)))
		{
			if(i == SaucerIndex)
			{
				//sub_702D
				Var(RAM_SaucerCountdown) = Var(RAM_SaucerCountdownStart);
				VarO(RAMO_Status, SaucerIndex) = 0;
				VarO(RAMO_VelocityX, SaucerIndex) = 0;
				VarO(RAMO_VelocityY, SaucerIndex) = 0;
				return;
			}
		}
		MakeBytesFromWord(xPosition, VarO(RAMO_PositionX, i), VarO(RAMO_PositionExactX, i));
		//loc_6FEC
		//VarO(RAMO_PositionX, i) = a;

		word yPosition = MakeWord(VarO(RAMO_PositionY, i), VarO(RAMO_PositionExactY, i));
		yPosition = MoveLinearY(yPosition, VarO(RAMO_VelocityY, i), 1);
		MakeBytesFromWord(yPosition, VarO(RAMO_PositionY, i), VarO(RAMO_PositionExactY, i));

/*		y = 0;
		a = VarO(RAMO_VelocityY, i);
		if(char(a) < 0)
			y--;
		bool c = false;
		Add(a, VarO(RAMO_PositionExactY, i), c);
		VarO(RAMO_PositionExactY, i) = a;
		a = y;
		Add(a, VarO(RAMO_PositionY, i), c);
		if(a >= 0x18)
		{
			if(a == 0x18)
			{//loc_7011
				a = 0;
			}
			else
				a = 0x17;
		}
		//loc_7013
		VarO(RAMO_PositionY, i) = a;*/

		/*a = VarO(RAMO_Status, i);
		y = 0xE0;
		if((a&1) == 0)
		{
			y = 0xF0;
			if((a&2) == 0)
				y = 0;
		}*/
		sub_72FE(i);
	}

	void sub_72FE(int i)
	{
	/*	byte tmp0 = y;
		bool c = false;
		a = tmp5;
		ShiftRight(a, c);
		RollRight(tmp4, c);
		ShiftRight(a, c);
		RollRight(tmp4, c);
		ShiftRight(a, c);
		RollRight(tmp4, c);
		tmp5 = a;

		a = tmp7+4;
		c = false;
		ShiftRight(a, c);
		RollRight(tmp6, c);
		ShiftRight(a, c);
		RollRight(tmp6, c);
		ShiftRight(a, c);
		RollRight(tmp6, c);
		tmp7 = a;
		byte x = 4;
		//sub_7C1C
		a = 0x70;
		a -= tmp0;
		while(char(a) >= 0xA0)
		{
			byte stack = a;
			a = 0x90;
			//sub_7CDE
			a = stack;
			a -= 0x10;
		}
		//loc_733B
		//sub_7CDE
		a = VarO(RAMO_Status, i);
		if(char(a) >= 0)
		{//loc_735B
		}
		if(i != PlayerIndex)
		{
			y = (a&0x0C)>>1;
//				a = 50F8[y];
//				x = 50F9[y];
			if(x != 0)
			{
				//loc_7370
			}
		}
		{//sub_7465
			
		}*/
//loc_7384:
		//...
		if(i>SaucerIndex && (Var(RAM_FastTimer)&3) == 0)
		{
			VarO(RAMO_Status, i)--;
			if(!updating && !VarO(RAMO_Status, i))
			{//////////
				printf("Shot %i ins Leere gegangen um %x\n", i-PlayerShotMinIndex, Var(RAM_FastTimer));
				ErrorsOccured = true;
			}
		}
	}

	void ResetAsteroids();


	void ResetPlayerPosition()//sub_71E8
	{
		VarO(RAMO_PositionX, PlayerIndex) = 0x10;
		VarO(RAMO_PositionY, PlayerIndex) = 0x0C;

		VarO(RAMO_PositionExactX, PlayerIndex) = 0x60;
		VarO(RAMO_PositionExactY, PlayerIndex) = 0x60;

		VarO(RAMO_VelocityX, PlayerIndex) = 0;
		VarO(RAMO_VelocityY, PlayerIndex) = 0;
	}

	static void CosLookup(byte& a)//sub_77D2
	{
		a += 0x40;
		SinLookup(a);
	}

	static void SinLookup(byte& a)//sub_77D5
	{
		const byte Table[0x41] =//0x57B9
		{
			0x00, 0x03, 0x06, 0x09, 0x0c, 0x10, 0x13, 0x16, 0x19, 0x1c, 0x1f, 0x22, 0x25, 0x28,
			0x2b, 0x2e, 0x31, 0x33, 0x36, 0x39, 0x3c, 0x3f, 0x41, 0x44, 0x47, 0x49, 0x4c, 0x4e,
			0x51, 0x53, 0x55, 0x58, 0x5a, 0x5c, 0x5e, 0x60, 0x62, 0x64, 0x66, 0x68, 0x6a, 0x6b,
			0x6d, 0x6f, 0x70, 0x71, 0x73, 0x74, 0x75, 0x76, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 0x7c,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f
		};
		bool inv = false;
		if(char(a) < 0)
		{
			inv = true;
			a &= 0x7F;
		}
		if(a >= 0x41)
			a = (a^0x7F) + 1;
		a = Table[a];
		if(inv)
			a = (a^0xFF) + 1;
	}

	void sub7125(byte& a, byte& x)
	{
		if(char(a) >= 0)
		{
			if(a >= 0x40)
			{
				x = 0xFF;
				a = 0x3F;
			}
		}
		else
		{
			if(a < 0xC0)
			{
				x = 1;
				a = 0xC0;
			}
		}
	}

	void CloneAsteroid(byte dest, byte src)//sub_6A9D
	{
		VarO(RAMO_Status, dest) = (VarO(RAMO_Status, src)&7) | (Rand()&0x18);
		VarO(RAMO_PositionX, dest) = VarO(RAMO_PositionX, src);
		VarO(RAMO_PositionY, dest) = VarO(RAMO_PositionY, src);
		VarO(RAMO_PositionExactX, dest) = VarO(RAMO_PositionExactX, src);
		VarO(RAMO_PositionExactY, dest) = VarO(RAMO_PositionExactY, src);
		VarO(RAMO_VelocityX, dest) = VarO(RAMO_VelocityX, src);
		VarO(RAMO_VelocityY, dest) = VarO(RAMO_VelocityY, src);
	}

	void SplitAsteroid(byte CollisionCauser, byte Asteroid)//Erzeugt zwei kleine Asteroiden
	{//sub_75EC
		//byte a = VarO(RAMO_Status, y);
		//a &= 0x78;
		//byte tmp_e = a;
		byte NewStatus = (VarO(RAMO_Status, Asteroid)&7) >> 1;
		if(Var(RAM_NumPlayers) && (CollisionCauser == PlayerIndex || CollisionCauser >= PlayerShotMinIndex))
		{
			//Der Schuss ist vom Spieler oder der Spieler kollidiert selber mit dem Asteroid
			if(NewStatus == 0)
				AddScore(10);
			else if(NewStatus == 1)
				AddScore(5);
			else if(NewStatus == 2)
				AddScore(2);
			else
				assert(0);
		}
		if(NewStatus)
			VarO(RAMO_Status, Asteroid) = (NewStatus | (VarO(RAMO_Status, Asteroid)&0x78));
		else
		{
			VarO(RAMO_Status, Asteroid) = 0;
			return;
		}
		byte NewAsteroid = NextAsteroidSlot(PlayerIndex-1);
		if(NewAsteroid == 0xFF)
		{//////////
			//MessageBeep(0);
			//printf("Keine Slots mehr uebrig!!\n");
			return;
		}
		Var(RAM_NumAsteroids)++;
		CloneAsteroid(NewAsteroid, Asteroid);
		sub_7203(NewAsteroid, Asteroid);
		VarO(RAMO_PositionExactX, NewAsteroid) ^= (VarO(RAMO_VelocityX, NewAsteroid)&0x1F) << 1;
		NewAsteroid = NextAsteroidSlot(NewAsteroid-1);
		if(NewAsteroid == 0xFF)
		{
			//MessageBeep(0);
			//printf("Nur noch ein Slot uebrig!!\n");
			return;
		}
		Var(RAM_NumAsteroids)++;
		CloneAsteroid(NewAsteroid, Asteroid);
		sub_7203(NewAsteroid, Asteroid);
		VarO(RAMO_PositionExactY, NewAsteroid) ^= (VarO(RAMO_VelocityY, NewAsteroid)&0x1F) << 1;
	}

	byte NextAsteroidSlot(byte StartSearchAt)
	{//sub_745A
		byte i = StartSearchAt;
		while(i!=0xFF && VarO(RAMO_Status, i))
			i--;
		return i;
	}

	void sub_7203(byte& x, byte& y)
	{
		byte a = Rand() & 0x8F;
		if(char(a) < 0)
			a |= 0xF0;
		a += VarO(RAMO_VelocityX, y);
		sub_7233(a);
		VarO(RAMO_VelocityX, x) = a;
	
		Rand(); Rand(); Rand();

		a = Rand() & 0x8F;
		if(char(a) < 0)
			a |= 0xF0;
		a += VarO(RAMO_VelocityY, y);
		sub_7233(a);
		VarO(RAMO_VelocityY, x) = a;
	}

	void sub_7233(byte& a)
	{
		if(char(a) < 0)
		{
			if(a < 0xE1)
				a = 0xE1;
			else if(a >= 0xFB)
				a = 0xFA;
		}
		else
		{
			if(a < 6)
				a = 6;
			else if(a >= 0x20)
				a = 0x1F;
		}
	}

	void AddScore(byte add)
	{//sub_7397
		word score = DecimalToBin(Var(RAM_PlayerScoreThousends), Var(RAM_PlayerScoreTens));
		if(score/1000 != (score+add)/1000)
			Var(RAM_cShips)++;
		score += add;
		if(pScore)
			*pScore += add;
		BinToDecimal(score, Var(RAM_PlayerScoreThousends), Var(RAM_PlayerScoreTens));
	}
	void CheckCollisions(byte CollisionCauser);

	static bool AreObjectsNear(byte i, word iPositionX, word iPositionY, byte iStatus,
							   byte j, word jPositionX, word jPositionY, byte jStatus)
	{//Ship/Saucer/Shots muss in i sein, Asteroiden in j
		byte a = LowByte(jPositionX);
		bool c = true;
		Subtract(a, LowByte(iPositionX), c);
		byte tmp8 = a;
		a = HighByte(jPositionX);
		Subtract(a, HighByte(iPositionX), c);
		ShiftRight(a, c);
		RotateRight(tmp8, c);
		ShiftLeft(a, c);
		if(a)
		{
			if(char(a) >= 0)
				return false;
			a ^= 0xFE;
			if(a)
				return false;
			tmp8 ^= 0xFF;
		}
		a = LowByte(jPositionY);
		c = true;
		Subtract(a, LowByte(iPositionY), c);
		byte tmp9 = a;
		a = HighByte(jPositionY);
		Subtract(a, HighByte(iPositionY), c);
		ShiftRight(a, c);
		RotateRight(tmp9, c);
		ShiftLeft(a, c);
		if(a)
		{
			if(char(a) >= 0)
				return false;
			a ^= 0xFE;
			if(a)
				return false;
			tmp9 ^= 0xFF;
		}
		a = 0x2A;
		ShiftRight(jStatus, c);
		if(!c)
		{
			a = 0x48;
			ShiftRight(jStatus, c);
			if(!c)
				a = 0x84;
		}
		if(i == PlayerIndex)
			a += 0x1C;
		else if(i == SaucerIndex)
		{
			c = true;
			Add(a, 0x12, c);
			if(iStatus != 1)
				Add(a, 0x12, c);
		}
		if(a < tmp8) return false;
		if(a < tmp9) return false;
		byte tmp = a;
		a >>= 1;
		c = false;
		Add(a, tmp, c);
		tmp = a;
		a = tmp9;
		Add(a, tmp8, c);
		if(c) return false;
		if(a >= tmp) return false;
		return true;
	}

	// Gibt zurck, ob sich die Asteroiden oder das UFO gendert haben
	bool OnCollision(byte CollisionCauser, byte& y)//sub_6B0F
	{
		if(CollisionCauser != SaucerIndex)
		{
			if(CollisionCauser != PlayerIndex)
			{
				// CollisionCauser ist ein Schuss
				VarO(RAMO_Status, CollisionCauser) = 0; //Schuss lschen
				if(y == PlayerIndex)
				{
					Var(RAM_cShips)--;
					Var(RAM_InvisibleTimer) = 0x81;
				}
				else if(y > PlayerIndex)
					DestroySaucer();
				else
					SplitAsteroid(CollisionCauser, y);
				VarO(RAMO_Status, y) = 0xA0;
				VarO(RAMO_VelocityX, y) = 0;
				VarO(RAMO_VelocityY, y) = 0;
				return y != PlayerIndex;
			}
			Var(RAM_InvisibleTimer) = 0x81;
			Var(RAM_cShips)--;
			CollisionCauser = PlayerIndex;
		}
		else if(y == PlayerIndex)
		{
			CollisionCauser = PlayerIndex;
			y = SaucerIndex;
			Var(RAM_InvisibleTimer) = 0x81;
			Var(RAM_cShips)--;
		}
		VarO(RAMO_Status, CollisionCauser) = 0xA0;
		VarO(RAMO_VelocityX, CollisionCauser) = 0;
		VarO(RAMO_VelocityY, CollisionCauser) = 0;
		if(y < PlayerIndex)
		{
			SplitAsteroid(CollisionCauser, y);
		}
		else
		{
			DestroySaucer();
		}
		VarO(RAMO_Status, y) = 0xA0;
		VarO(RAMO_VelocityX, y) = 0;
		VarO(RAMO_VelocityY, y) = 0;
		return true;
	}

	void DestroySaucer()
	{
		Var(RAM_SaucerCountdown) = Var(RAM_SaucerCountdownStart);
		if(Var(RAM_NumPlayers))
		{
			if(VarO(RAMO_Status, SaucerIndex) == 1)
				AddScore(99);
			else
				AddScore(20);
		}
	}

	byte Rand()
	{
		byte& s1 = Var(RAM_RandomSeed1);
		byte& s2 = Var(RAM_RandomSeed2);
		bool carry = false;
		ShiftLeft(s1, carry);
		if(char(RotateLeft(s2, carry)) < 0)
			s1++;
		if(s1 & 2)
			s1 ^= 1;
		if((s1|s2) == 0)
			s1++;
		return s1;
	}
};

struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-byte zurck
	byte ram[0x300];
};

#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
private:
	SOCKET sd;
	ADDRESS server_ip;
};
